package net.kldp.logviewer;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

import net.kldp.logviewer.common.log.LogViews;
import net.kldp.logviewer.define.LogDefine;
import net.kldp.logviewer.model.GetLogDBInfo;
import net.kldp.logviewer.model.LogViewerEntry;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;

public class AllLogView extends ViewPart {
	private static final Logger logger = LogViews.getLogger(AllLogView.class);

	public static final String ID = "net.kldp.logviewer.AllLogView"; // TODO Needs to be whatever is mentioned in plugin.xml
	private LogViewerEntry viewEntry = null;
	private Composite top = null;

	private StyledText styledText = null;
	
	public void init(IViewSite site) throws PartInitException {
		super.init(site);
		
		// ȭ鿡 ϰ ϴ viewer  ´.
		GetLogDBInfo gli = new GetLogDBInfo();
		viewEntry = gli.getLeaf(site.getSecondaryId());
		
		setPartName(viewEntry.getName() + " üα");		
	}

	
	public void createPartControl(Composite parent) {
		// TODO Auto-generated method stub
		GridData gridData = new GridData();
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;  // Generated
		gridData.grabExcessHorizontalSpace = true;  // Generated
		gridData.grabExcessVerticalSpace = true;  // Generated
		gridData.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;  // Generated
		top = new Composite(parent, SWT.NONE);
		top.setLayout(new GridLayout());
		styledText = new StyledText(top, SWT.NONE);
		styledText.setLayoutData(gridData);  // Generated
		
		int intFont = Integer.parseInt(viewEntry.getFont());		
		int intFontSize = Integer.parseInt(viewEntry.getFontSize());
		
		String arryFontCol[] = StringUtils.split(viewEntry.getFontcolor(), '|');				
		Color colFont = new Color(parent.getShell().getDisplay(), 
								Integer.parseInt(arryFontCol[0]), 
								Integer.parseInt(arryFontCol[1]), 
								Integer.parseInt(arryFontCol[2])
					);
		
		String arryBackCol[] = StringUtils.split(viewEntry.getBackGroundColor(), '|');				
		Color colBack = new Color(parent.getShell().getDisplay(), 
								Integer.parseInt(arryBackCol[0]), 
								Integer.parseInt(arryBackCol[1]), 
								Integer.parseInt(arryBackCol[2])
					);
		
		Font font = new Font(parent.getShell().getDisplay(), 
				LogDefine.FONTS[intFont],
				Integer.parseInt(LogDefine.FONT_SIZES[intFontSize]),
				SWT.NORMAL
			);
		
		// StyledText  Ѵ.
		styledText.setFont(font);
		styledText.setForeground(colFont);
		styledText.setBackground(colBack);
		
		BufferedInputStream bis = null;
		try {
			bis = new BufferedInputStream(new FileInputStream(viewEntry.getPath()), 1024);
			int length = bis.available();					
			if (length == -1) throw new IOException("File End Exception");							
						
			byte[] data = new byte[length];							
			while (bis.read(data, 0, length) == -1);
			
			// ȭ鿡 ͸ ش.
			styledText.setText(new String(data));
			
		} catch(IOException ioe) {
			styledText.setText(ioe.getMessage());
		} finally {
			try { bis.close(); } catch(IOException ioe){}
		}
	}

	
	public void setFocus() {
		styledText.setFocus();
	}

}
